//
//  RootViewController.m
//  Enabling Paging with UIPageViewController
//
//  Created by Vandad Nahavandipoor on 11/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "RootViewController.h"

#import "ModelController.h"

#import "DataViewController.h"

@interface RootViewController ()
@property (readonly, strong, nonatomic) ModelController *modelController;
@end

@implementation RootViewController

@synthesize pageViewController = _pageViewController;
@synthesize modelController = _modelController;

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Usunięcie wszelkich buforowanych danych, obrazów itd., które nie są obecnie używane.
}

#pragma mark - Cykl życiowy widoku

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Wszelka konfiguracja dodatkowa po wczytaniu widoku, najczęściej z pliku nib.
  // Konfiguracja kontrolera widoku strony i jego dodanie jako potomnego kontrolera widoku.
  self.pageViewController = [[UIPageViewController alloc] initWithTransitionStyle:UIPageViewControllerTransitionStylePageCurl navigationOrientation:UIPageViewControllerNavigationOrientationHorizontal options:nil];
  self.pageViewController.delegate = self;

  DataViewController *startingViewController = [self.modelController viewControllerAtIndex:0];
  NSArray *viewControllers = [NSArray arrayWithObject:startingViewController];
  [self.pageViewController setViewControllers:viewControllers direction:UIPageViewControllerNavigationDirectionForward animated:NO completion:NULL];

  self.pageViewController.dataSource = self.modelController;

  [self addChildViewController:self.pageViewController];
  [self.view addSubview:self.pageViewController.view];

  // Określenie wymiarów kontrolera widoku w taki sposób, aby widok główny był widoczny wokół krawędzi stron.
  CGRect pageViewRect = self.view.bounds;
  if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad) {
      pageViewRect = CGRectInset(pageViewRect, 40.0, 40.0);
  }
  self.pageViewController.view.frame = pageViewRect;

  [self.pageViewController didMoveToParentViewController:self];    

  // Dodanie procedur rozpoznawania gestów kontrolera widoku strony do kontrolera widoku książki, aby wspomniane gesty były łatwiej uruchamiane.
  self.view.gestureRecognizers = self.pageViewController.gestureRecognizers;
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Usunięcie wszystkich "przytrzymanych" podwidoków widoku głównego,
// na przykład self.myOutlet = nil;
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
}

- (void)viewWillDisappear:(BOOL)animated
{
	[super viewWillDisappear:animated];
}

- (void)viewDidDisappear:(BOOL)animated
{
	[super viewDidDisappear:animated];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Zwrot wartości YES dla obsługiwanych układów.
  if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
      return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
  } else {
      return YES;
  }
}

- (ModelController *)modelController
{
    /*
     Zwrot obiektu kontrolera modelu tworząc go, jeśli zajdzie potrzeba.
     W bardziej skomplikowanych implementacjach, kontroler modelu może być przekazany kontrolerowi widoku.
     */
    if (!_modelController) {
        _modelController = [[ModelController alloc] init];
    }
    return _modelController;
}

#pragma mark - UIPageViewController delegate methods

/*
- (void)pageViewController:(UIPageViewController *)pageViewController didFinishAnimating:(BOOL)finished previousViewControllers:(NSArray *)previousViewControllers transitionCompleted:(BOOL)completed
{
    
}
 */



- (UIPageViewControllerSpineLocation)pageViewController:(UIPageViewController *)pageViewController spineLocationForInterfaceOrientation:(UIInterfaceOrientation)orientation
{
  
  if (UIInterfaceOrientationIsPortrait(orientation) || ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone)) {
      // W układzie pionowym lub w iPhone: ustaw pozycję "min", a tablica kontrolerów widoku będzie zawierała tylko jeden kontroler widoku. Wybranie położenia UIPageViewControllerSpineLocationMid powoduje, że trybie poziomym właściwość doubleSided będzie miała przypisaną wartość YES więc tutaj przypisujemy jej wartość NO.
      
      UIViewController *currentViewController = [self.pageViewController.viewControllers objectAtIndex:0];
      NSArray *viewControllers = [NSArray arrayWithObject:currentViewController];
      [self.pageViewController setViewControllers:viewControllers direction:UIPageViewControllerNavigationDirectionForward animated:YES completion:NULL];
      
      self.pageViewController.doubleSided = NO;
      return UIPageViewControllerSpineLocationMin;
  }

  // W układzie poziomym: ustaw pozycję "mid", a tablica kontrolerów widoku będzie zawierała dwa kontrolery widoku. Jeżeli bieżąca strona jest parzysta, powinna mieć przypisany bieżący i następny kontroler widoku. W przypadku strony nieparzystej tablica powinna zawierać poprzedni i bieżący kontroler widoku.
  DataViewController *currentViewController = [self.pageViewController.viewControllers objectAtIndex:0];
  NSArray *viewControllers = nil;

  NSUInteger indexOfCurrentViewController = [self.modelController indexOfViewController:currentViewController];
  if (indexOfCurrentViewController == 0 || indexOfCurrentViewController % 2 == 0) {
      UIViewController *nextViewController = [self.modelController pageViewController:self.pageViewController viewControllerAfterViewController:currentViewController];
      viewControllers = [NSArray arrayWithObjects:currentViewController, nextViewController, nil];
  } else {
      UIViewController *previousViewController = [self.modelController pageViewController:self.pageViewController viewControllerBeforeViewController:currentViewController];
      viewControllers = [NSArray arrayWithObjects:previousViewController, currentViewController, nil];
  }
  [self.pageViewController setViewControllers:viewControllers direction:UIPageViewControllerNavigationDirectionForward animated:YES completion:NULL];


  return UIPageViewControllerSpineLocationMid;
}

@end
